#ifndef INDATA_H
#define INDATA_H

#include <map>
#include <cmath>

#include "POF/NN_data.h"

struct Indata {
	double normaltable[n_label][MAX_n_rank][MAX_n_class][2] {}; //2,5,10,2
	double postprob[n_label][MAX_n_class][MAX_n_rank] {}; //2,10,5
	int normaltable_eff[n_label][MAX_n_class][MAX_n_internal_test_case][2] {}; //2,10,5000,2
};

void init_indata(struct Indata** p_indata);
void print_indata(struct Indata* indata);
double get_posterior(struct Indata* indata, int i, int j, int k);

void set_normaltable(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);
void set_posterior(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);
void set_bias(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);
void update_indata(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);
double compute_effans(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);
#endif